/*
 * @brief LPC5411X SPI driver
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2015
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licenser disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "chip.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/
/* Initialize SPI Interface */
int Chip_SPI_Init(LPC_SPI_T *pSPI)
{
	int ret;
	ret = Chip_FLEXCOMM_Init(pSPI, FLEXCOMM_PERIPH_SPI);
	if (!ret) { /* Enable the FIFOs */
		Chip_SPI_SetFIFOCfg(pSPI, SPI_FIFOCFG_ENABLETX | SPI_FIFOCFG_ENABLERX);
		Chip_SPI_FlushFifos(pSPI);
		Chip_SPI_SetFIFOTrigLevel(pSPI, 4, 0);
	}
	return ret;
}

/* Setup SAPI configuration */
void Chip_SPI_ConfigureSPI(LPC_SPI_T *pSPI, SPI_CFGSETUP_T *pCFG)
{
	uint32_t reg;

	/* Get register and mask off config bits this function alters */
	reg = pSPI->CFG & ~(SPI_CFG_MASTER_EN | SPI_CFG_LSB_FIRST_EN |
						SPI_CFG_CPHA_SECOND | SPI_CFG_CPOL_HI);

	if (pCFG->master) {
		reg |= SPI_CFG_MASTER_EN;
	}
	if (pCFG->lsbFirst) {
		reg |= SPI_CFG_LSB_FIRST_EN;
	}
	reg |= (uint32_t) pCFG->mode;

	Chip_SPI_SetCFGRegBits(pSPI, reg);

	/* De-assert all slave selects */
	Chip_SPI_SetTXCTRLRegBits(pSPI, SPI_TXDATCTL_DEASSERT_ALL);
}
